-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self, source, target)
  if not self.initialized then
    self.initialized = true
		self.limit = {}
        
    if not self.loaded then
      self.active = true
      self.limitSetter = 0
      self.attCounter = 0
      self.difCoef = Citadels.GetPlayer(0):GetDifficultyCoef()
      SetAi(self)
    end
		
    SetLimit(self)		
		
		if not self.loaded then
			self.timer = self.limit[0]
		end		
		
    self.handlerWeak:LinkToTarget("attWeak")
    self.handlerMedium:LinkToTarget("attMedium")
    self.handlerStrong:LinkToTarget("attStrong")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      HandleAttacks(self)
      GetNewLimit(self)      
      self.timer = self.limit[self.limitSetter]
      self.active = false
    end
  end  
end

function HandleAttacks(self)
  if self.attCounter < 3 then
    self.handlerWeak:TriggerAllTargets()
  elseif self.attCounter < 6 then
    self.handlerMedium:TriggerAllTargets()
  else
    self.handlerStrong:TriggerAllTargets()
  end
  self.attCounter = self.attCounter + 1
end

function SetAi(self)
  self.p1 = Citadels.GetPlayer(1)
  self.p1:AISetAutoMode(true)
  self.p1:AISetEverythingVisible(true)
end

function SetLimit(self)
	self.limit[0] = 660 / self.difCoef
  self.limit[1] = 480 / self.difCoef
  self.limit[2] = 360 / self.difCoef
  self.limit[3] = 180 / self.difCoef
end

function GetNewLimit(self)
	if self.attCounter <= 3 then
		self.limitSetter = 1
  elseif self.attCounter > 3 and self.attCounter <= 7 then
    self.limitSetter = 2
  elseif self.attCounter > 7 then
    self.limitSetter = 3
  else
    return
  end
end

function OnTrigger(self, source, target)
  if target == "activateAttHandler" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.limitSetter = ar:Read()
    self.attCounter = ar:Read()
    self.difCoef = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.limitSetter)
    ar:Write(self.attCounter)
    ar:Write(self.difCoef)
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("activateAttHandler")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("handlerWeak")
  self:AddTriggerSource("handlerMedium")
  self:AddTriggerSource("handlerStrong")
end

